from torchvision import datasets, transforms
import numpy as np


# specify available data-sets.
AVAILABLE_DATASETS = {
    'mnist': datasets.MNIST,
    'cifar100': datasets.CIFAR100,
    'cifar10': datasets.CIFAR10,
}


# specify configurations of available data-sets.
DATASET_CONFIGS = {
    'mnist': {'size': 32, 'channels': 1, 'classes': 10},
    'mnist28': {'size': 28, 'channels': 1, 'classes': 10},
    'cifar100': {'size': 32, 'channels': 3, 'classes': 100},
    'cifar10': {'size': 32, 'channels': 3, 'classes': 100},
}

# specify available transforms.
AVAILABLE_TRANSFORMS = {
    'mnist': [
        transforms.Pad(2),
        transforms.ToTensor(),
    ],
    'mnist28': [
        transforms.ToTensor(),
    ],
    'cifar100_train': [
        transforms.ToTensor(),
        transforms.Normalize(mean=[0.5071, 0.4865, 0.4409], std=[0.2673, 0.2564, 0.2761]),
    ],
    'cifar100_test': [
        transforms.ToTensor(),
        transforms.Normalize(mean=[0.5071, 0.4865, 0.4409], std=[0.2673, 0.2564, 0.2761]),
    ],
    'cifar10_train': [
        transforms.RandomCrop(32, padding=4),
        transforms.RandomHorizontalFlip(),
        transforms.ToTensor(),
        transforms.Normalize((0.4914, 0.4822, 0.4465), (0.2023, 0.1994, 0.2010)),
    ],
    'cifar10_test': [
        transforms.ToTensor(),
        transforms.Normalize((0.4914, 0.4822, 0.4465), (0.2023, 0.1994, 0.2010)),
    ],  
}


labels_per_tasks_overlap = {
    'splitMNIST': [
            [[0, 1, 2, 3], [2, 3, 4], [3, 4], [5, 6, 7, 8], [7, 8, 9]],
            [[0, 1, 2, 3], [2, 3], [4, 5, 6, 7], [7, 8, 9]],
            [[0, 1], [1, 2], [3, 4], [4, 5, 6], [5, 6, 7], [7, 8], [8, 9]],
            [[0, 1], [1, 2, 3, 4], [5, 6], [7, 8, 9]],
            [[0, 1, 2, 3], [1, 2, 3], [4, 5], [6, 7, 8, 9]]],
    'cifar10': [
            [[0, 1, 2, 3], [2, 3, 4], [3, 4], [5, 6, 7, 8], [7, 8, 9]],
            [[0, 1, 2, 3], [2, 3], [4, 5, 6, 7], [7, 8, 9]],
            [[0, 1], [1, 2], [3, 4], [4, 5, 6], [5, 6, 7], [7, 8], [8, 9]],
            [[0, 1], [1, 2, 3, 4], [5, 6], [7, 8, 9]],
            [[0, 1, 2, 3], [1, 2, 3], [4, 5], [6, 7, 8, 9]]],
    'cifar100': [
            [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10], [8, 9, 10, 11, 12, 13, 14, 15, 16, 17], [16, 17, 18, 19, 20, 21, 22], [17, 18, 19, 20, 21, 22, 23, 24, 25, 26], [20, 21, 22, 23, 24, 25, 26], [21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31], [31, 32, 33, 34, 35, 36, 37, 38], [37, 38, 39, 40, 41, 42, 43], [43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53], [54, 55, 56, 57, 58, 59, 60, 61, 62], [58, 59, 60, 61, 62, 63, 64, 65, 66, 67], [66, 67, 68, 69, 70, 71, 72], [67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77], [75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85], [86, 87, 88, 89, 90, 91, 92, 93, 94], [88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
            [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11], [6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17], [8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20], [15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27], [20, 21, 22, 23, 24, 25, 26, 27], [26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37], [35, 36, 37, 38, 39, 40, 41, 42, 43], [44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55], [47, 48, 49, 50, 51, 52, 53, 54, 55, 56], [56, 57, 58, 59, 60, 61, 62, 63, 64], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [66, 67, 68, 69, 70, 71, 72, 73, 74, 75], [74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84], [79, 80, 81, 82, 83, 84, 85, 86, 87, 88], [86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98], [88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
            [[0, 1, 2, 3, 4, 5, 6, 7], [7, 8, 9, 10, 11, 12, 13, 14, 15], [14, 15, 16, 17, 18, 19, 20], [19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37], [29, 30, 31, 32, 33, 34, 35, 36, 37, 38], [33, 34, 35, 36, 37, 38, 39, 40, 41], [41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53], [48, 49, 50, 51, 52, 53, 54], [52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63], [53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72], [73, 74, 75, 76, 77, 78, 79, 80, 81, 82], [77, 78, 79, 80, 81, 82, 83, 84, 85, 86], [81, 82, 83, 84, 85, 86, 87, 88, 89], [89, 90, 91, 92, 93, 94, 95, 96, 97, 98], [92, 93, 94, 95, 96, 97, 98, 99]],
            [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10], [6, 7, 8, 9, 10, 11, 12, 13], [7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18], [14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26], [20, 21, 22, 23, 24, 25, 26, 27, 28], [29, 30, 31, 32, 33, 34, 35], [31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41], [33, 34, 35, 36, 37, 38, 39, 40, 41, 42], [35, 36, 37, 38, 39, 40, 41, 42, 43], [42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54], [52, 53, 54, 55, 56, 57, 58, 59], [53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63], [62, 63, 64, 65, 66, 67, 68], [63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73], [69, 70, 71, 72, 73, 74, 75], [72, 73, 74, 75, 76, 77, 78, 79], [78, 79, 80, 81, 82, 83, 84, 85, 86], [86, 87, 88, 89, 90, 91, 92, 93, 94, 95], [93, 94, 95, 96, 97, 98, 99]],
            [[0, 1, 2, 3, 4, 5, 6, 7, 8], [4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15], [6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17], [8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20], [19, 20, 21, 22, 23, 24, 25], [24, 25, 26, 27, 28, 29, 30], [31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42], [41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51], [47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58], [57, 58, 59, 60, 61, 62, 63], [62, 63, 64, 65, 66, 67, 68, 69], [63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76], [77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88], [82, 83, 84, 85, 86, 87, 88], [89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99]]],
    'permMNIST': [
            [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10], [8, 9, 10, 11, 12, 13, 14, 15, 16, 17], [16, 17, 18, 19, 20, 21, 22], [17, 18, 19, 20, 21, 22, 23, 24, 25, 26], [20, 21, 22, 23, 24, 25, 26], [21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31], [31, 32, 33, 34, 35, 36, 37, 38], [37, 38, 39, 40, 41, 42, 43], [43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53], [54, 55, 56, 57, 58, 59, 60, 61, 62], [58, 59, 60, 61, 62, 63, 64, 65, 66, 67], [66, 67, 68, 69, 70, 71, 72], [67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77], [75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85], [86, 87, 88, 89, 90, 91, 92, 93, 94], [88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
            [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11], [6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17], [8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20], [15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27], [20, 21, 22, 23, 24, 25, 26, 27], [26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37], [35, 36, 37, 38, 39, 40, 41, 42, 43], [44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55], [47, 48, 49, 50, 51, 52, 53, 54, 55, 56], [56, 57, 58, 59, 60, 61, 62, 63, 64], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [66, 67, 68, 69, 70, 71, 72, 73, 74, 75], [74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84], [79, 80, 81, 82, 83, 84, 85, 86, 87, 88], [86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98], [88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
            [[0, 1, 2, 3, 4, 5, 6, 7], [7, 8, 9, 10, 11, 12, 13, 14, 15], [14, 15, 16, 17, 18, 19, 20], [19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37], [29, 30, 31, 32, 33, 34, 35, 36, 37, 38], [33, 34, 35, 36, 37, 38, 39, 40, 41], [41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53], [48, 49, 50, 51, 52, 53, 54], [52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63], [53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72], [73, 74, 75, 76, 77, 78, 79, 80, 81, 82], [77, 78, 79, 80, 81, 82, 83, 84, 85, 86], [81, 82, 83, 84, 85, 86, 87, 88, 89], [89, 90, 91, 92, 93, 94, 95, 96, 97, 98], [92, 93, 94, 95, 96, 97, 98, 99]],
            [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10], [6, 7, 8, 9, 10, 11, 12, 13], [7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18], [14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26], [20, 21, 22, 23, 24, 25, 26, 27, 28], [29, 30, 31, 32, 33, 34, 35], [31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41], [33, 34, 35, 36, 37, 38, 39, 40, 41, 42], [35, 36, 37, 38, 39, 40, 41, 42, 43], [42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54], [52, 53, 54, 55, 56, 57, 58, 59], [53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63], [62, 63, 64, 65, 66, 67, 68], [63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73], [69, 70, 71, 72, 73, 74, 75], [72, 73, 74, 75, 76, 77, 78, 79], [78, 79, 80, 81, 82, 83, 84, 85, 86], [86, 87, 88, 89, 90, 91, 92, 93, 94, 95], [93, 94, 95, 96, 97, 98, 99]],
            [[0, 1, 2, 3, 4, 5, 6, 7, 8], [4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15], [6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17], [8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20], [19, 20, 21, 22, 23, 24, 25], [24, 25, 26, 27, 28, 29, 30], [31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42], [41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51], [47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58], [57, 58, 59, 60, 61, 62, 63], [62, 63, 64, 65, 66, 67, 68, 69], [63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76], [77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88], [82, 83, 84, 85, 86, 87, 88], [89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99]]],
}


labels_per_tasks_nooverlap = {
    'splitMNIST': [
        [[5, 4, 3, 1], [9, 7, 0], [6, 8, 2]],
        [[5, 7], [6, 1], [3, 0, 9, 4], [8, 2]],
        [[4, 6], [8, 0], [3, 9], [7, 1, 2, 5]],
        [[5, 8], [6, 3, 9, 1], [2, 0, 4, 7]],
        [[4, 0], [8, 1, 9], [5, 6], [2, 7, 3]]],
    'cifar10': [
        [[5, 4, 3, 1], [9, 7, 0], [6, 8, 2]],
        [[5, 7], [6, 1], [3, 0, 9, 4], [8, 2]],
        [[4, 6], [8, 0], [3, 9], [7, 1, 2, 5]],
        [[5, 8], [6, 3, 9, 1], [2, 0, 4, 7]],
        [[4, 0], [8, 1, 9], [5, 6], [2, 7, 3]]],
    'cifar100': [
        [[19, 10, 80, 53, 95, 60, 75, 81, 16, 82, 65, 83, 97], [45, 74, 54, 27, 66, 12, 20, 77, 0, 55, 59, 92], [29, 63, 58, 52, 87, 26, 69, 76, 8, 50, 93, 33], [7, 78, 44, 70, 32, 98, 43], [1, 23, 36, 99, 72, 37, 90, 35, 11, 48, 22], [4, 25, 71, 21, 94, 2, 68, 96, 67, 28], [30, 85, 49, 51, 3, 64, 88, 24, 91, 57, 13, 17, 9], [89, 39, 40, 84, 41, 6, 47, 61, 42, 79, 15, 14, 46], [73, 38, 86, 18, 62, 34, 56, 31, 5]],
        [[98, 27, 49, 39, 14, 53, 96, 1, 60, 16], [12, 51, 83, 97, 72, 32, 55, 15, 20, 63, 46], [64, 7, 75, 62, 74, 40, 77, 69, 26, 94, 3], [38, 9, 45, 23, 31, 54, 25, 79, 35, 11, 19, 70, 84], [21, 99, 24, 44, 8, 67, 82], [47, 33, 88, 57, 6, 56, 2], [10, 95, 89, 4, 13, 50, 81, 42, 66, 30], [91, 0, 65, 86, 87, 73, 36, 29, 43], [85, 59, 41, 52, 28, 93, 37, 76, 92], [80, 90, 61, 22, 5, 71, 58, 18, 17, 78, 34, 68, 48]],
        [[56, 97, 30, 17, 63, 15, 92, 6], [64, 71, 86, 91, 32, 42, 90, 7, 55], [23, 50, 22, 53, 16, 1, 94, 19, 66, 72, 41, 85, 5], [73, 29, 21, 75, 58, 87, 11], [28, 49, 99, 35, 31, 34, 80], [37, 40, 52, 47, 95, 88, 98], [10, 78, 24, 70, 60, 20, 14, 54], [83, 93, 82, 8, 67, 79, 65, 38, 61, 36, 81, 2], [39, 4, 62, 59, 89, 68, 57, 51, 3], [69, 77, 45, 27, 43, 76, 9, 74, 48, 44, 25], [33, 84, 13, 12, 18, 96, 0, 26, 46]],
        [[55, 63, 74, 2, 7, 23, 3, 37, 88], [87, 75, 73, 32, 39, 16, 5, 21, 30, 10, 66], [86, 51, 33, 98, 6, 29, 79, 99, 25, 91, 22, 95, 57], [76, 50, 72, 70, 8, 81, 34], [28, 20, 94, 56, 9, 48, 53, 65, 83, 77, 12, 67, 58], [59, 1, 90, 17, 19, 36, 45, 11, 44, 80, 64, 35], [46, 40, 78, 89, 92, 18, 71, 4, 84, 0, 93, 97], [61, 60, 54, 41, 96, 15, 38, 68, 13, 82, 27], [43, 49, 47, 26, 62, 14, 69, 52, 31, 24, 42, 85]],
        [[38, 17, 46, 85, 9, 1, 94, 43, 67], [37, 68, 91, 50, 86, 56, 58, 5, 41, 80, 92, 51], [31, 83, 64, 14, 25, 76, 53], [2, 95, 96, 28, 32, 35, 55, 13, 72], [81, 33, 70, 24, 52, 8, 87, 3, 29, 30, 61, 47, 16], [93, 82, 48, 21, 90, 23, 89, 18, 62, 27, 39], [75, 15, 97, 0, 45, 59, 44], [65, 11, 34, 10, 99, 40, 20], [60, 7, 74, 73, 22, 66, 19, 63, 77], [6, 79, 57, 84, 49, 98, 54, 69], [4, 12, 26, 42, 71, 88, 36, 78]]],
    'permMNIST': [
        [[19, 10, 80, 53, 95, 60, 75, 81, 16, 82, 65, 83, 97], [45, 74, 54, 27, 66, 12, 20, 77, 0, 55, 59, 92], [29, 63, 58, 52, 87, 26, 69, 76, 8, 50, 93, 33], [7, 78, 44, 70, 32, 98, 43], [1, 23, 36, 99, 72, 37, 90, 35, 11, 48, 22], [4, 25, 71, 21, 94, 2, 68, 96, 67, 28], [30, 85, 49, 51, 3, 64, 88, 24, 91, 57, 13, 17, 9], [89, 39, 40, 84, 41, 6, 47, 61, 42, 79, 15, 14, 46], [73, 38, 86, 18, 62, 34, 56, 31, 5]],
        [[98, 27, 49, 39, 14, 53, 96, 1, 60, 16], [12, 51, 83, 97, 72, 32, 55, 15, 20, 63, 46], [64, 7, 75, 62, 74, 40, 77, 69, 26, 94, 3], [38, 9, 45, 23, 31, 54, 25, 79, 35, 11, 19, 70, 84], [21, 99, 24, 44, 8, 67, 82], [47, 33, 88, 57, 6, 56, 2], [10, 95, 89, 4, 13, 50, 81, 42, 66, 30], [91, 0, 65, 86, 87, 73, 36, 29, 43], [85, 59, 41, 52, 28, 93, 37, 76, 92], [80, 90, 61, 22, 5, 71, 58, 18, 17, 78, 34, 68, 48]],
        [[56, 97, 30, 17, 63, 15, 92, 6], [64, 71, 86, 91, 32, 42, 90, 7, 55], [23, 50, 22, 53, 16, 1, 94, 19, 66, 72, 41, 85, 5], [73, 29, 21, 75, 58, 87, 11], [28, 49, 99, 35, 31, 34, 80], [37, 40, 52, 47, 95, 88, 98], [10, 78, 24, 70, 60, 20, 14, 54], [83, 93, 82, 8, 67, 79, 65, 38, 61, 36, 81, 2], [39, 4, 62, 59, 89, 68, 57, 51, 3], [69, 77, 45, 27, 43, 76, 9, 74, 48, 44, 25], [33, 84, 13, 12, 18, 96, 0, 26, 46]],
        [[55, 63, 74, 2, 7, 23, 3, 37, 88], [87, 75, 73, 32, 39, 16, 5, 21, 30, 10, 66], [86, 51, 33, 98, 6, 29, 79, 99, 25, 91, 22, 95, 57], [76, 50, 72, 70, 8, 81, 34], [28, 20, 94, 56, 9, 48, 53, 65, 83, 77, 12, 67, 58], [59, 1, 90, 17, 19, 36, 45, 11, 44, 80, 64, 35], [46, 40, 78, 89, 92, 18, 71, 4, 84, 0, 93, 97], [61, 60, 54, 41, 96, 15, 38, 68, 13, 82, 27], [43, 49, 47, 26, 62, 14, 69, 52, 31, 24, 42, 85]],
        [[38, 17, 46, 85, 9, 1, 94, 43, 67], [37, 68, 91, 50, 86, 56, 58, 5, 41, 80, 92, 51], [31, 83, 64, 14, 25, 76, 53], [2, 95, 96, 28, 32, 35, 55, 13, 72], [81, 33, 70, 24, 52, 8, 87, 3, 29, 30, 61, 47, 16], [93, 82, 48, 21, 90, 23, 89, 18, 62, 27, 39], [75, 15, 97, 0, 45, 59, 44], [65, 11, 34, 10, 99, 40, 20], [60, 7, 74, 73, 22, 66, 19, 63, 77], [6, 79, 57, 84, 49, 98, 54, 69], [4, 12, 26, 42, 71, 88, 36, 78]]],       
}

labels_per_tasks_standard = {
    'splitMNIST': [
        [[0, 1], [2, 3], [4, 5], [6, 7], [8, 9]],
        [[0, 1], [2, 3], [4, 5], [6, 7], [8, 9]],
        [[0, 1], [2, 3], [4, 5], [6, 7], [8, 9]],
        [[0, 1], [2, 3], [4, 5], [6, 7], [8, 9]],
        [[0, 1], [2, 3], [4, 5], [6, 7], [8, 9]]],
    'splitMNISToneclass': [
        [[0], [1], [2], [3], [4], [5], [6], [7], [8], [9]],
        [[0], [1], [2], [3], [4], [5], [6], [7], [8], [9]],
        [[0], [1], [2], [3], [4], [5], [6], [7], [8], [9]],
        [[0], [1], [2], [3], [4], [5], [6], [7], [8], [9]],
        [[0], [1], [2], [3], [4], [5], [6], [7], [8], [9]]],
    'cifar10': [
        [[0, 1], [2, 3], [4, 5], [6, 7], [8, 9]],
        [[0, 1], [2, 3], [4, 5], [6, 7], [8, 9]],
        [[0, 1], [2, 3], [4, 5], [6, 7], [8, 9]],
        [[0, 1], [2, 3], [4, 5], [6, 7], [8, 9]],
        [[0, 1], [2, 3], [4, 5], [6, 7], [8, 9]]],
    'cifar100': [
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]]],
    'permMNIST': [
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]],
        [[0, 1, 2, 3, 4, 5, 6, 7, 8, 9], [10, 11, 12, 13, 14, 15, 16, 17, 18, 19], [20, 21, 22, 23, 24, 25, 26, 27, 28, 29], [30, 31, 32, 33, 34, 35, 36, 37, 38, 39], [40, 41, 42, 43, 44, 45, 46, 47, 48, 49], [50, 51, 52, 53, 54, 55, 56, 57, 58, 59], [60, 61, 62, 63, 64, 65, 66, 67, 68, 69], [70, 71, 72, 73, 74, 75, 76, 77, 78, 79], [80, 81, 82, 83, 84, 85, 86, 87, 88, 89], [90, 91, 92, 93, 94, 95, 96, 97, 98, 99]]],
}




